# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_ARABIC} "(Use CD)"
LangString ReadOnly ${LANG_ARABIC} "(Read Only)"
LangString MainHeaderSubText ${LANG_ARABIC} "        "
LangString MainLanguageLabel ${LANG_ARABIC} ":"
LangString MainUsernameLabel ${LANG_ARABIC} " :"
LangString MainPasswordLabel ${LANG_ARABIC} " :"
LangString MainInstallationSizeLabel ${LANG_ARABIC} "  ( )"
LangString MainDistroLabel ${LANG_ARABIC} "  :"
LangString MainInstallationDriveLabel ${LANG_ARABIC} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_ARABIC} "Installation language."
LangString MainUsernameToolTip ${LANG_ARABIC} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_ARABIC} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_ARABIC} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_ARABIC} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_ARABIC} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_ARABIC} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_ARABIC} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_ARABIC} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_ARABIC} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_ARABIC} "    "
LangString ErrorSpaceInUsername ${LANG_ARABIC} "      ."
LangString ErrorUsernameUpperCase ${LANG_ARABIC} "      ."
LangString ErrorUsernameFirstCharNotLetter ${LANG_ARABIC} "     ."
LangString ErrorUsernameIllegalChars ${LANG_ARABIC} "          ."
LangString ErrorReservedUsername ${LANG_ARABIC} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_ARABIC} "    ."
LangString ErrorPasswordMismatch ${LANG_ARABIC} "   ."
LangString ErrorSpaceInPassword ${LANG_ARABIC} "      ."
LangString ErrorNoFreeSpace ${LANG_ARABIC} "Not enough free space."
LangString ErrorNoKernel ${LANG_ARABIC} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_ARABIC} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_ARABIC} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_ARABIC} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_ARABIC} "   :"
LangString ErrorNoCD ${LANG_ARABIC} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_ARABIC} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_ARABIC} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_ARABIC} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_ARABIC} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_ARABIC} "       "
LangString InstallHeaderUncompressWubifolder ${LANG_ARABIC} "     wubi ..."
LangString InstallHeaderCopyIso ${LANG_ARABIC} "   ..."
LangString InstallHeaderDownload ${LANG_ARABIC} "      "
LangString InstallHeaderBackupIso ${LANG_ARABIC} "    ..."
LangString InstallHeaderWritePreseed ${LANG_ARABIC} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_ARABIC} "   ..."
LangString InstallHeaderWriteBootLoader ${LANG_ARABIC} "   ..."
LangString InstallGenerateVirtualDisks ${LANG_ARABIC} "   ..."
LangString InstallCopyFiles ${LANG_ARABIC} "   ..."
LangString InstallCreateFolders ${LANG_ARABIC} "Creating folders..."
LangString InstallRetrieveIso ${LANG_ARABIC} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_ARABIC} "${AppName} is already installed"
LangString UninstallAsk ${LANG_ARABIC} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_ARABIC} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_ARABIC} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_ARABIC} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_ARABIC} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_ARABIC} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_ARABIC} "      ."

# DOWNLOADER
LangString MetadlDownloading ${LANG_ARABIC} "Downloading installation files..."
LangString MetadlChecking ${LANG_ARABIC} "Checking installation files..."
LangString MetadlConnecting ${LANG_ARABIC} "   %s..."
LangString MetadlInitializing ${LANG_ARABIC} "Initializing..."
LangString MetadlChecksums ${LANG_ARABIC} "  checksum ..."
LangString MetadlRetrying1 ${LANG_ARABIC} "   %d   ... (%d  %d)"
LangString MetadlRetrying2 ${LANG_ARABIC} "   %d   ..."
LangString MetadlSecond ${LANG_ARABIC} ""
LangString MetadlSeconds ${LANG_ARABIC} ""
LangString MetadlProgress ${LANG_ARABIC} "%s (%d%%)  %s @ %s/s"
LangString MetadlRemaining ${LANG_ARABIC} " (%s )"
LangString PleaseConnect ${LANG_ARABIC} "    ."

# ACCESSIBILITY
LangString MobilityAids ${LANG_ARABIC} "Mobility Aids"
LangString VisibilityAids ${LANG_ARABIC} "Visibility Aids"
LangString AccessibilityButton ${LANG_ARABIC} "&Accessibility"
LangString AccessibilityText ${LANG_ARABIC} "Accessibility profile"
LangString AccessibilitySubText ${LANG_ARABIC} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_ARABIC} "None"
LangString VisibilityHighContrast ${LANG_ARABIC} "High Contrast"
LangString VisibilityMagnifier ${LANG_ARABIC} "Magnifier"
LangString VisibilityScreenReader ${LANG_ARABIC} "Screen Reader"
LangString VisibilityBraille ${LANG_ARABIC} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_ARABIC} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_ARABIC} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_ARABIC} "Install CD booter"
LangString CDBootText ${LANG_ARABIC} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_ARABIC} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_ARABIC} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_ARABIC} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_ARABIC} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_ARABIC} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
